/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.MongoOpsUtil;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoEventSourceSettings;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoPersistenceOperationsSelection;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoPersistenceOperationsSelectionProvider;
import org.eclipse.ditto.internal.utils.persistence.operations.NamespacePersistenceOperations;

public final class MongoNamespacePersistenceOperations
implements NamespacePersistenceOperations {
    private final MongoDatabase db;
    private final MongoPersistenceOperationsSelectionProvider selectionProvider;

    private MongoNamespacePersistenceOperations(MongoDatabase db, MongoEventSourceSettings eventSourceSettings) {
        this.db = (MongoDatabase)ConditionChecker.checkNotNull((Object)db, (String)"database");
        this.selectionProvider = MongoPersistenceOperationsSelectionProvider.of(eventSourceSettings);
    }

    public static MongoNamespacePersistenceOperations of(MongoDatabase db, MongoEventSourceSettings eventSourceSettings) {
        return new MongoNamespacePersistenceOperations(db, eventSourceSettings);
    }

    @Override
    public Source<List<Throwable>, NotUsed> purge(CharSequence namespace) {
        return this.purgeAllSelections(this.selectNamespace(namespace));
    }

    private Collection<MongoPersistenceOperationsSelection> selectNamespace(CharSequence namespace) {
        return this.selectionProvider.selectNamespace(namespace);
    }

    private Source<List<Throwable>, NotUsed> purgeAllSelections(Iterable<MongoPersistenceOperationsSelection> selections) {
        Source result = Source.empty();
        for (MongoPersistenceOperationsSelection mongoOpsSelection : selections) {
            Source<List<Throwable>, NotUsed> purge = this.purge(mongoOpsSelection);
            result = result.merge(purge);
        }
        return result;
    }

    private Source<List<Throwable>, NotUsed> purge(MongoPersistenceOperationsSelection selection) {
        MongoCollection collection = this.db.getCollection(selection.getCollectionName());
        if (selection.isEntireCollection()) {
            return MongoOpsUtil.drop((MongoCollection<Document>)collection);
        }
        return MongoOpsUtil.deleteByFilter((MongoCollection<Document>)collection, (Bson)selection.getFilter());
    }
}

