/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource;

import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.bson.Document;

@Immutable
final class MongoPersistenceOperationsSelection {
    private final String collectionName;
    private final Document filter;

    private MongoPersistenceOperationsSelection(String collectionName, Document filter) {
        this.collectionName = Objects.requireNonNull(collectionName);
        this.filter = filter;
    }

    public static MongoPersistenceOperationsSelection of(String collectionName, Document filter) {
        return new MongoPersistenceOperationsSelection(collectionName, filter);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Document getFilter() {
        return new Document((Map)this.filter);
    }

    public boolean isEntireCollection() {
        return this.filter.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoPersistenceOperationsSelection that = (MongoPersistenceOperationsSelection)o;
        return Objects.equals(this.collectionName, that.collectionName) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.collectionName, this.filter);
    }

    public String toString() {
        return String.format("%s (%s)", this.collectionName, this.isEntireCollection() ? "complete" : "filtered: " + this.filter);
    }
}

