/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource;

import akka.contrib.persistence.mongodb.JournallingFieldNames$;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.Document;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoEventSourceSettings;
import org.eclipse.ditto.internal.utils.persistence.mongo.ops.eventsource.MongoPersistenceOperationsSelection;

@Immutable
final class MongoPersistenceOperationsSelectionProvider {
    private static final String PID = JournallingFieldNames$.MODULE$.PROCESSOR_ID();
    private final MongoEventSourceSettings settings;

    private MongoPersistenceOperationsSelectionProvider(MongoEventSourceSettings settings) {
        this.settings = (MongoEventSourceSettings)ConditionChecker.checkNotNull((Object)settings, (String)"MongoEventSourceSettings");
    }

    public static MongoPersistenceOperationsSelectionProvider of(MongoEventSourceSettings settings) {
        return new MongoPersistenceOperationsSelectionProvider(settings);
    }

    public Collection<MongoPersistenceOperationsSelection> selectEntity(EntityId entityId) {
        ConditionChecker.checkNotNull((Object)entityId, (String)"entity ID");
        return Collections.unmodifiableList(Arrays.asList(this.selectEntityByPid(this.settings.getMetadataCollectionName(), entityId), this.selectEntityByPid(this.settings.getJournalCollectionName(), entityId), this.selectEntityByPid(this.settings.getSnapshotCollectionName(), entityId)));
    }

    public Collection<MongoPersistenceOperationsSelection> selectNamespace(CharSequence namespace) {
        ConditionChecker.checkNotNull((Object)namespace, (String)"namespace");
        if (!this.settings.isSupportsNamespaces()) {
            throw new UnsupportedOperationException("Namespaces are not supported!");
        }
        return Collections.unmodifiableList(Arrays.asList(this.selectNamespaceByPid(this.settings.getMetadataCollectionName(), namespace), this.selectNamespaceByPid(this.settings.getJournalCollectionName(), namespace), this.selectNamespaceByPid(this.settings.getSnapshotCollectionName(), namespace)));
    }

    private MongoPersistenceOperationsSelection selectNamespaceByPid(String collection, CharSequence namespace) {
        return MongoPersistenceOperationsSelection.of(collection, this.filterByPidPrefix(namespace));
    }

    private Document filterByPidPrefix(CharSequence namespace) {
        String pidRegex = String.format("^%s%s:", this.settings.getPersistenceIdPrefix(), namespace);
        return new Document(PID, (Object)new BsonRegularExpression(pidRegex));
    }

    private MongoPersistenceOperationsSelection selectEntityByPid(String collection, EntityId entityId) {
        return MongoPersistenceOperationsSelection.of(collection, this.filterByPid(entityId));
    }

    private Document filterByPid(EntityId entityId) {
        String pid = String.format("%s%s", this.settings.getPersistenceIdPrefix(), entityId);
        return new Document(PID, (Object)new BsonString(pid));
    }
}

