/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.internal.utils.persistence.operations;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.internal.utils.config.ConfigWithFallback;
import org.eclipse.ditto.internal.utils.config.KnownConfigValue;
import org.eclipse.ditto.internal.utils.persistence.operations.PersistenceOperationsConfig;

@Immutable
public final class DefaultPersistenceOperationsConfig
implements PersistenceOperationsConfig {
    private static final String CONFIG_PATH = "persistence.operations";
    private final Duration delayAfterPersistenceActorShutdown;

    private DefaultPersistenceOperationsConfig(ConfigWithFallback configWithFallback) {
        this.delayAfterPersistenceActorShutdown = configWithFallback.getDuration(PersistenceOperationsConfig.PersistenceOperationsConfigValue.DELAY_AFTER_PERSISTENCE_ACTOR_SHUTDOWN.getConfigPath());
    }

    public static DefaultPersistenceOperationsConfig of(Config config) {
        return new DefaultPersistenceOperationsConfig(ConfigWithFallback.newInstance((Config)config, (String)CONFIG_PATH, (KnownConfigValue[])PersistenceOperationsConfig.PersistenceOperationsConfigValue.values()));
    }

    @Override
    public Duration getDelayAfterPersistenceActorShutdown() {
        return this.delayAfterPersistenceActorShutdown;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPersistenceOperationsConfig that = (DefaultPersistenceOperationsConfig)o;
        return Objects.equals(this.delayAfterPersistenceActorShutdown, that.delayAfterPersistenceActorShutdown);
    }

    public int hashCode() {
        return Objects.hash(this.delayAfterPersistenceActorShutdown);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [delayAfterPersistenceActorShutdown=" + this.delayAfterPersistenceActorShutdown + "]";
    }
}

