/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.base.assertions;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.assertions.AbstractJsonifiableAssert;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.signals.base.assertions.WithDittoHeadersChecker;
import org.eclipse.ditto.signals.commands.base.Command;

public abstract class AbstractCommandAssert<S extends AbstractCommandAssert<S, C>, C extends Command>
extends AbstractJsonifiableAssert<S, C> {
    private final WithDittoHeadersChecker withDittoHeadersChecker;

    protected AbstractCommandAssert(C actual, Class<? extends AbstractCommandAssert> selfType) {
        super(actual, selfType);
        this.withDittoHeadersChecker = new WithDittoHeadersChecker(actual);
    }

    public S withType(CharSequence expectedType) {
        return this.assertThatEquals(((Command)this.actual).getType(), String.valueOf(expectedType), "type");
    }

    public S hasDittoHeaders(DittoHeaders expectedDittoHeaders) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasDittoHeaders(expectedDittoHeaders);
        return (S)((Object)((AbstractCommandAssert)this.myself));
    }

    public S hasCorrelationId(CharSequence expectedCorrelationId) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasCorrelationId(expectedCorrelationId);
        return (S)((Object)((AbstractCommandAssert)this.myself));
    }

    public S withDittoHeaders(DittoHeaders expectedDittoHeaders) {
        return this.assertThatEquals(((Command)this.actual).getDittoHeaders(), expectedDittoHeaders, "command headers");
    }

    public S withResourcePath(JsonPointer expectedResourcePath) {
        return this.assertThatEquals(((Command)this.actual).getResourcePath(), expectedResourcePath, "resource path");
    }

    public S withManifest(CharSequence expectedManifest) {
        return this.assertThatEquals(((Command)this.actual).getManifest(), String.valueOf(expectedManifest), "manifest");
    }

    protected <T> S assertThatEquals(T actual, T expected, String propertyName) {
        ((ObjectAssert)Assertions.assertThat(actual).overridingErrorMessage("Expected Command to have %s\n<%s> but it had\n<%s>", new Object[]{propertyName, expected, actual})).isEqualTo(expected);
        return (S)((Object)((AbstractCommandAssert)this.myself));
    }
}

