/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.base.assertions;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.assertions.AbstractJsonifiableAssert;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.base.assertions.WithDittoHeadersChecker;
import org.eclipse.ditto.signals.commands.base.CommandResponse;

public abstract class AbstractCommandResponseAssert<S extends AbstractCommandResponseAssert<S, R>, R extends CommandResponse>
extends AbstractJsonifiableAssert<S, R> {
    private final WithDittoHeadersChecker withDittoHeadersChecker;

    protected AbstractCommandResponseAssert(R actual, Class<? extends AbstractCommandResponseAssert> selfType) {
        super(actual, selfType);
        this.withDittoHeadersChecker = new WithDittoHeadersChecker(actual);
    }

    public S hasType(CharSequence expectedType) {
        this.isNotNull();
        String actualType = ((CommandResponse)this.actual).getType();
        ((AbstractStringAssert)Assertions.assertThat((String)actualType).overridingErrorMessage("Expected CommandResponse to have type\n<%s> but it had\n<%s>", new Object[]{expectedType, actualType})).isEqualTo((Object)expectedType.toString());
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasName(CharSequence expectedName) {
        this.isNotNull();
        String actualName = ((CommandResponse)this.actual).getName();
        ((AbstractStringAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected CommandResponse to have name\n<%s> but it had\n<%s>", new Object[]{expectedName, actualName})).isEqualTo((Object)expectedName.toString());
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasDittoHeaders(DittoHeaders expectedDittoHeaders) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasDittoHeaders(expectedDittoHeaders);
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasEmptyDittoHeaders() {
        this.isNotNull();
        this.withDittoHeadersChecker.hasEmptyDittoHeaders();
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasCorrelationId(CharSequence expectedCorrelationId) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasCorrelationId(expectedCorrelationId);
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasJsonSchemaVersion(JsonSchemaVersion expectedJsonSchemaVersion) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasSchemaVersion(expectedJsonSchemaVersion);
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S containsAuthorizationSubject(String ... expectedAuthSubject) {
        this.isNotNull();
        this.withDittoHeadersChecker.containsAuthorizationSubject(expectedAuthSubject);
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasStatus(HttpStatusCode expectedStatusCode) {
        return this.assertThatEquals(((CommandResponse)this.actual).getStatusCode(), expectedStatusCode, "HTTP status");
    }

    public S hasStatusCode(int expectedStatusCodeValue) {
        return this.assertThatEquals(((CommandResponse)this.actual).getStatusCodeValue(), expectedStatusCodeValue, "HTTP status code");
    }

    private <T> S assertThatEquals(T actual, T expected, String propertyName) {
        ((ObjectAssert)Assertions.assertThat(actual).overridingErrorMessage("Expected CommandResponse to have %s \n<%s> but it had\n<%s>", new Object[]{propertyName, expected, actual})).isEqualTo(expected);
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasResourcePath(JsonPointer expectedResourcePath) {
        this.isNotNull();
        JsonPointer actualResourcePath = ((CommandResponse)this.actual).getResourcePath();
        ((ObjectAssert)Assertions.assertThat((Object)actualResourcePath).overridingErrorMessage("Expected CommandResponse to have resource path\n<%s> but it had\n<%s>", new Object[]{expectedResourcePath, actualResourcePath})).isEqualTo((Object)expectedResourcePath);
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }

    public S hasManifest(CharSequence expectedManifest) {
        this.isNotNull();
        String actualManifest = ((CommandResponse)this.actual).getManifest();
        ((AbstractStringAssert)Assertions.assertThat((String)actualManifest).overridingErrorMessage("Expected Event to have manifest\n<%s> but it had\n<%s>", new Object[]{expectedManifest, actualManifest})).isEqualTo((Object)expectedManifest);
        return (S)((Object)((AbstractCommandResponseAssert)this.myself));
    }
}

