/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.base.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.signals.base.assertions.WithDittoHeadersChecker;
import org.eclipse.ditto.signals.commands.base.ErrorResponse;

public class ErrorResponseAssert
extends AbstractAssert<ErrorResponseAssert, ErrorResponse> {
    private final WithDittoHeadersChecker withDittoHeadersChecker;

    public ErrorResponseAssert(ErrorResponse actual) {
        super((Object)actual, ErrorResponseAssert.class);
        this.withDittoHeadersChecker = new WithDittoHeadersChecker((WithDittoHeaders)actual);
    }

    public ErrorResponseAssert hasDittoHeaders(DittoHeaders expectedDittoHeaders) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasDittoHeaders(expectedDittoHeaders);
        return (ErrorResponseAssert)this.myself;
    }

    public ErrorResponseAssert hasEmptyDittoHeaders() {
        this.isNotNull();
        this.withDittoHeadersChecker.hasEmptyDittoHeaders();
        return (ErrorResponseAssert)this.myself;
    }

    public ErrorResponseAssert hasCorrelationId(CharSequence expectedCorrelationId) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasCorrelationId(expectedCorrelationId);
        return (ErrorResponseAssert)this.myself;
    }

    public ErrorResponseAssert hasType(String expectedType) {
        return this.assertThatEquals(((ErrorResponse)this.actual).getType(), expectedType, "type");
    }

    public ErrorResponseAssert hasStatusCode(HttpStatusCode expectedStatusCode) {
        return this.assertThatEquals(((ErrorResponse)this.actual).getStatusCode(), expectedStatusCode, "HTTP status code");
    }

    public ErrorResponseAssert contains(DittoRuntimeException expectedDittoRuntimeException) {
        return this.assertThatEquals(((ErrorResponse)this.actual).getDittoRuntimeException(), expectedDittoRuntimeException, "DittoRuntimeException");
    }

    public ErrorResponseAssert containsDittoRuntimeExceptionOfType(Class<? extends DittoRuntimeException> expectedType) {
        this.isNotNull();
        DittoRuntimeException actualDittoRuntimeException = ((ErrorResponse)this.actual).getDittoRuntimeException();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualDittoRuntimeException).overridingErrorMessage("Expected Thing Error Response to contain DittoRuntimeException of type <%s> but it did not", new Object[]{expectedType})).isInstanceOf(expectedType);
        return this;
    }

    public ErrorResponseAssert dittoRuntimeExceptionHasErrorCode(String expectedErrorCode) {
        this.isNotNull();
        DittoRuntimeException dittoRuntimeException = ((ErrorResponse)this.actual).getDittoRuntimeException();
        String actualErrorCode = dittoRuntimeException.getErrorCode();
        ((AbstractStringAssert)Assertions.assertThat((String)actualErrorCode).overridingErrorMessage("Expected DittoRuntimeException of Thing Error Response to have error code \n<%s> but it had \n<%s>", new Object[]{expectedErrorCode, actualErrorCode})).isEqualTo((Object)expectedErrorCode);
        return this;
    }

    private <T> ErrorResponseAssert assertThatEquals(T actual, T expected, String propertyName) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat(actual).overridingErrorMessage("Expected Thing Error Response to have %s \n<%s> but it had \n<%s>", new Object[]{propertyName, expected, actual})).isEqualTo(expected);
        return this;
    }
}

