/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.signals.base.WithIdButActuallyNot;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;

@Immutable
public abstract class CommonCommand<T extends CommonCommand>
extends AbstractCommand<T>
implements WithIdButActuallyNot {
    protected static final String TYPE_PREFIX = "common.commands:";
    protected static final String RESOURCE_TYPE = "common";
    private final Command.Category category;

    protected CommonCommand(String type, Command.Category category, DittoHeaders dittoHeaders) {
        super(type, dittoHeaders);
        this.category = (Command.Category)ConditionChecker.checkNotNull((Object)category, (String)"Category");
    }

    public Command.Category getCategory() {
        return this.category;
    }

    public String getTypePrefix() {
        return TYPE_PREFIX;
    }

    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    public JsonPointer getResourcePath() {
        return JsonFactory.emptyPointer();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommonCommand that = (CommonCommand)((Object)o);
        return that.canEqual((Object)this) && Objects.equals(this.category, that.category) && super.equals((Object)that);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CommonCommand;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.category);
    }

    public String toString() {
        return super.toString() + ", category=" + this.category;
    }
}

