/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.common.CommonCommandResponse;

@JsonParsableCommandResponse(type="common.responses:modifyConfig")
public final class ModifyConfigResponse
extends CommonCommandResponse<ModifyConfigResponse> {
    public static final String TYPE = "common.responses:modifyConfig";
    private static final JsonFieldDefinition<JsonObject> JSON_CONFIG = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"config", (JsonFieldMarker[])new JsonFieldMarker[0]);
    private final JsonObject config;

    private ModifyConfigResponse(JsonObject config, DittoHeaders dittoHeaders) {
        super(TYPE, HttpStatusCode.OK, dittoHeaders);
        this.config = config;
    }

    public static ModifyConfigResponse of(JsonObject config, DittoHeaders headers) {
        return new ModifyConfigResponse(config, headers);
    }

    public static ModifyConfigResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new ModifyConfigResponse((JsonObject)jsonObject.getValueOrThrow(JSON_CONFIG), dittoHeaders);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(JSON_CONFIG, (Object)this.config);
    }

    public ModifyConfigResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ModifyConfigResponse(this.config, dittoHeaders);
    }

    public boolean equals(Object that) {
        if (super.equals(that) && that instanceof ModifyConfigResponse) {
            return Objects.equals(this.config, ((ModifyConfigResponse)((Object)that)).config);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.config);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", config=" + this.config + "]";
    }
}

