/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommand;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.common.CommonCommand;

@JsonParsableCommand(typePrefix="common.commands:", name="retrieveConfig")
@Immutable
public final class RetrieveConfig
extends CommonCommand<RetrieveConfig> {
    static final String NAME = "retrieveConfig";
    public static final String TYPE = "common.commands:retrieveConfig";
    private static final JsonFieldDefinition<String> JSON_PATH = JsonFactory.newStringFieldDefinition((CharSequence)"path", (JsonFieldMarker[])new JsonFieldMarker[0]);
    @Nullable
    private final String path;

    private RetrieveConfig(@Nullable String path, DittoHeaders dittoHeaders) {
        super(TYPE, Command.Category.QUERY, dittoHeaders);
        this.path = path;
    }

    public static RetrieveConfig of() {
        return RetrieveConfig.of(null, DittoHeaders.empty());
    }

    public static RetrieveConfig of(@Nullable String path, DittoHeaders dittoHeaders) {
        return new RetrieveConfig(path, dittoHeaders);
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        if (this.path != null) {
            jsonObjectBuilder.set(JSON_PATH, (Object)this.path);
        }
    }

    public RetrieveConfig setDittoHeaders(DittoHeaders dittoHeaders) {
        return new RetrieveConfig(this.path, dittoHeaders);
    }

    public static RetrieveConfig fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        String path = jsonObject.getValue(JSON_PATH).orElse(null);
        return new RetrieveConfig(path, dittoHeaders);
    }

    @Override
    public boolean equals(Object that) {
        if (super.equals(that) && that instanceof RetrieveConfig) {
            return Objects.equals(this.path, ((RetrieveConfig)((Object)that)).path);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", path=" + this.path + "]";
    }
}

