/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.common.CommonCommandResponse;

@JsonParsableCommandResponse(type="common.responses:retrieveConfig")
public final class RetrieveConfigResponse
extends CommonCommandResponse<RetrieveConfigResponse> {
    public static final String TYPE = "common.responses:retrieveConfig";
    private static final JsonFieldDefinition<JsonValue> JSON_CONFIG = JsonFactory.newJsonValueFieldDefinition((CharSequence)"config", (JsonFieldMarker[])new JsonFieldMarker[0]);
    private final JsonValue config;

    private RetrieveConfigResponse(JsonValue config, DittoHeaders dittoHeaders) {
        super(TYPE, HttpStatusCode.OK, dittoHeaders);
        this.config = config;
    }

    public static RetrieveConfigResponse of(JsonValue config, DittoHeaders headers) {
        return new RetrieveConfigResponse(config, headers);
    }

    public static RetrieveConfigResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new RetrieveConfigResponse((JsonValue)jsonObject.getValueOrThrow(JSON_CONFIG), dittoHeaders);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(JSON_CONFIG, (Object)this.config);
    }

    public RetrieveConfigResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return new RetrieveConfigResponse(this.config, dittoHeaders);
    }

    public boolean equals(Object that) {
        if (super.equals(that) && that instanceof RetrieveConfigResponse) {
            return Objects.equals(this.config, ((RetrieveConfigResponse)((Object)that)).config);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.config);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", config=" + this.config + "]";
    }
}

