/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common.purge;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.common.CommonCommandResponse;

@JsonParsableCommandResponse(type="common.responses:purgeEntities")
@Immutable
public final class PurgeEntitiesResponse
extends CommonCommandResponse<PurgeEntitiesResponse> {
    public static final String TYPE = "common.responses:purgeEntities";
    private final String entityType;
    private final boolean successful;

    private PurgeEntitiesResponse(CharSequence entityType, boolean successful, DittoHeaders dittoHeaders) {
        super(TYPE, HttpStatusCode.OK, dittoHeaders);
        this.entityType = ((CharSequence)ConditionChecker.checkNotNull((Object)entityType)).toString();
        this.successful = successful;
    }

    public static PurgeEntitiesResponse successful(CharSequence entityType, DittoHeaders dittoHeaders) {
        return new PurgeEntitiesResponse(entityType, true, dittoHeaders);
    }

    public static PurgeEntitiesResponse failed(CharSequence entityType, DittoHeaders dittoHeaders) {
        return new PurgeEntitiesResponse(entityType, false, dittoHeaders);
    }

    public static PurgeEntitiesResponse fromJson(JsonObject jsonObject, DittoHeaders headers) {
        return (PurgeEntitiesResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String parsedEntityType = (String)jsonObject.getValueOrThrow(JsonFields.ENTITY_TYPE);
            boolean parsedSuccessful = (Boolean)jsonObject.getValueOrThrow(JsonFields.SUCCESSFUL);
            return new PurgeEntitiesResponse((CharSequence)parsedEntityType, parsedSuccessful, headers);
        });
    }

    public String getEntityType() {
        return this.entityType;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public PurgeEntitiesResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return new PurgeEntitiesResponse((CharSequence)this.entityType, this.successful, dittoHeaders);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PurgeEntitiesResponse that = (PurgeEntitiesResponse)((Object)o);
        return Objects.equals(this.entityType, that.entityType) && this.successful == that.successful;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PurgeEntitiesResponse;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entityType, this.successful);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> aPredicate) {
        Predicate predicate = schemaVersion.and(aPredicate);
        jsonObjectBuilder.set(JsonFields.ENTITY_TYPE, (Object)this.entityType, predicate);
        jsonObjectBuilder.set(JsonFields.SUCCESSFUL, (Object)this.successful, predicate);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", entityType=" + this.entityType + ", successful=" + this.successful + "]";
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<String> ENTITY_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"entityType", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Boolean> SUCCESSFUL = JsonFactory.newBooleanFieldDefinition((CharSequence)"successful", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

