/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommand;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.common.CommonCommand;

@JsonParsableCommand(typePrefix="common.commands:", name="modifyConfig")
public final class ModifyConfig
extends CommonCommand<ModifyConfig> {
    public static final String NAME = "modifyConfig";
    public static final String TYPE = "common.commands:modifyConfig";
    private static final JsonFieldDefinition<JsonObject> JSON_CONFIG = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"config", (JsonFieldMarker[])new JsonFieldMarker[0]);
    private final JsonObject config;

    private ModifyConfig(JsonObject config, DittoHeaders dittoHeaders) {
        super(TYPE, Command.Category.MODIFY, dittoHeaders);
        this.config = config;
    }

    public static ModifyConfig of(JsonObject config, DittoHeaders headers) {
        return new ModifyConfig(config, headers);
    }

    public static ModifyConfig fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new ModifyConfig((JsonObject)jsonObject.getValueOrThrow(JSON_CONFIG), dittoHeaders);
    }

    public JsonObject getConfig() {
        return this.config;
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(JSON_CONFIG, (Object)this.config);
    }

    public ModifyConfig setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ModifyConfig(this.config, dittoHeaders);
    }

    @Override
    public boolean equals(Object that) {
        if (super.equals(that) && that instanceof ModifyConfig) {
            return Objects.equals(this.config, ((ModifyConfig)((Object)that)).config);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.config);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", config=" + this.config + "]";
    }
}

