/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.common.ShutdownReason;
import org.eclipse.ditto.signals.commands.common.ShutdownReasonType;

@Immutable
final class PurgeEntitiesReason
implements ShutdownReason {
    private static final ShutdownReasonType type = ShutdownReasonType.Known.PURGE_ENTITIES;
    private final List<String> entityIdsToPurge;

    private PurgeEntitiesReason(List<String> entityIdsToPurge) {
        this.entityIdsToPurge = entityIdsToPurge;
    }

    public static PurgeEntitiesReason of(List<EntityId> entityIdsToPurge) {
        List<String> stringEntityIdsToPurge = ((List)ConditionChecker.argumentNotEmpty(entityIdsToPurge, (String)"entities to purge")).stream().map(String::valueOf).collect(Collectors.toList());
        return new PurgeEntitiesReason(stringEntityIdsToPurge);
    }

    static PurgeEntitiesReason fromJson(JsonObject jsonObject) {
        List<String> entityIdsToPurge = ((JsonValue)jsonObject.getValueOrThrow(ShutdownReason.JsonFields.DETAILS)).asArray().stream().map(JsonValue::asString).collect(Collectors.toList());
        return new PurgeEntitiesReason(entityIdsToPurge);
    }

    @Override
    public ShutdownReasonType getType() {
        return type;
    }

    @Override
    public boolean isRelevantFor(Object value) {
        if (value instanceof CharSequence) {
            return this.entityIdsToPurge.contains(value.toString());
        }
        return false;
    }

    public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.REGULAR.and(FieldType.notHidden()));
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        Predicate extendedPredicate = schemaVersion.and(predicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(ShutdownReason.JsonFields.TYPE, (Object)this.getType().toString(), extendedPredicate);
        jsonObjectBuilder.set(ShutdownReason.JsonFields.DETAILS, (Object)JsonArray.of(this.entityIdsToPurge), extendedPredicate);
        return jsonObjectBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurgeEntitiesReason that = (PurgeEntitiesReason)o;
        return this.entityIdsToPurge.equals(that.entityIdsToPurge);
    }

    public int hashCode() {
        return Objects.hash(this.entityIdsToPurge);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [entityIdsToPurge=" + this.entityIdsToPurge + "]";
    }
}

