/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.common.ShutdownReason;
import org.eclipse.ditto.signals.commands.common.ShutdownReasonType;

@Immutable
final class PurgeNamespaceReason
implements ShutdownReason {
    private static final ShutdownReasonType type = ShutdownReasonType.Known.PURGE_NAMESPACE;
    private final String namespaceToPurge;

    private PurgeNamespaceReason(String namespaceToPurge) {
        this.namespaceToPurge = namespaceToPurge;
    }

    public static PurgeNamespaceReason of(CharSequence namespace) {
        return new PurgeNamespaceReason(ConditionChecker.argumentNotEmpty((CharSequence)namespace, (String)"namespace").toString());
    }

    static PurgeNamespaceReason fromJson(JsonObject jsonObject) {
        return new PurgeNamespaceReason(((JsonValue)jsonObject.getValueOrThrow(ShutdownReason.JsonFields.DETAILS)).asString());
    }

    @Override
    public ShutdownReasonType getType() {
        return type;
    }

    @Override
    public boolean isRelevantFor(Object value) {
        return this.namespaceToPurge.equals(value);
    }

    public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.REGULAR.and(FieldType.notHidden()));
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        Predicate extendedPredicate = schemaVersion.and(predicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(ShutdownReason.JsonFields.TYPE, (Object)this.getType().toString(), extendedPredicate);
        jsonObjectBuilder.set(ShutdownReason.JsonFields.DETAILS, (Object)JsonValue.of((String)this.namespaceToPurge), extendedPredicate);
        return jsonObjectBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurgeNamespaceReason that = (PurgeNamespaceReason)o;
        return Objects.equals(this.namespaceToPurge, that.namespaceToPurge);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceToPurge);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [namespaceToPurge=" + this.namespaceToPurge + "]";
    }
}

