/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonParsableCommand;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.common.CommonCommand;
import org.eclipse.ditto.signals.commands.common.ShutdownReason;
import org.eclipse.ditto.signals.commands.common.ShutdownReasonFactory;

@JsonParsableCommand(typePrefix="common.commands:", name="shutdown")
@Immutable
public final class Shutdown
extends CommonCommand<Shutdown> {
    static final String NAME = "shutdown";
    public static final String TYPE = "common.commands:shutdown";
    private final ShutdownReason reason;

    private Shutdown(ShutdownReason theReason, DittoHeaders dittoHeaders) {
        super(TYPE, Command.Category.MODIFY, dittoHeaders);
        this.reason = (ShutdownReason)ConditionChecker.checkNotNull((Object)theReason, (String)"ShutdownReason");
    }

    public static Shutdown getInstance(ShutdownReason shutdownReason, DittoHeaders dittoHeaders) {
        return new Shutdown(shutdownReason, dittoHeaders);
    }

    public static Shutdown fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (Shutdown)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> Shutdown.getInstance(ShutdownReasonFactory.fromJson(jsonObject.getValue(JsonFields.REASON).orElseGet(JsonObject::empty)), dittoHeaders));
    }

    public ShutdownReason getReason() {
        return this.reason;
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        Predicate<JsonField> isNonEmptyObject = field -> field.getValue().isObject() && !field.getValue().asObject().isEmpty();
        jsonObjectBuilder.set(JsonFields.REASON, (Object)((JsonObject)this.reason.toJson(schemaVersion, predicate)), schemaVersion.and(predicate).and(predicate).and(isNonEmptyObject));
    }

    public Shutdown setDittoHeaders(DittoHeaders dittoHeaders) {
        if (Objects.equals(this.getDittoHeaders(), dittoHeaders)) {
            return this;
        }
        return new Shutdown(this.reason, dittoHeaders);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Shutdown that = (Shutdown)((Object)o);
        return that.canEqual((Object)this) && Objects.equals(this.reason, that.reason) && super.equals((Object)that);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Shutdown;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reason);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", reason=" + this.reason + "]";
    }

    @Immutable
    public static final class JsonFields
    extends Command.JsonFields {
        public static final JsonFieldDefinition<JsonObject> REASON = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"reason", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

