/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.signals.commands.common.PurgeEntitiesReason;
import org.eclipse.ditto.signals.commands.common.PurgeNamespaceReason;
import org.eclipse.ditto.signals.commands.common.ShutdownNoReason;
import org.eclipse.ditto.signals.commands.common.ShutdownReason;
import org.eclipse.ditto.signals.commands.common.ShutdownReasonType;

@Immutable
public final class ShutdownReasonFactory {
    private ShutdownReasonFactory() {
        throw new AssertionError();
    }

    public static ShutdownReason fromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"reason JSON object");
        ShutdownReasonType type = ShutdownReasonFactory.getReasonType(jsonObject);
        if (ShutdownReasonType.Known.PURGE_NAMESPACE.equals(type)) {
            return PurgeNamespaceReason.fromJson(jsonObject);
        }
        if (ShutdownReasonType.Known.PURGE_ENTITIES.equals(type)) {
            return PurgeEntitiesReason.fromJson(jsonObject);
        }
        return ShutdownNoReason.INSTANCE;
    }

    private static ShutdownReasonType getReasonType(JsonObject shutdownReasonJson) {
        String typeName = shutdownReasonJson.getValue(ShutdownReason.JsonFields.TYPE).orElse("");
        return ShutdownReasonType.Known.forTypeName(typeName).orElseGet(() -> ShutdownReasonType.Unknown.of(typeName));
    }

    public static ShutdownReason getPurgeNamespaceReason(CharSequence namespace) {
        return PurgeNamespaceReason.of(namespace);
    }

    public static ShutdownReason getPurgeEntitiesReason(List<EntityId> entityIds) {
        return PurgeEntitiesReason.of(entityIds);
    }
}

