/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface ShutdownReasonType
extends CharSequence {

    public static enum Known implements ShutdownReasonType
    {
        PURGE_NAMESPACE("purge-namespace"),
        PURGE_ENTITIES("purge-entities");

        private final String typeName;

        private Known(String theTypeName) {
            this.typeName = theTypeName;
        }

        public static Optional<ShutdownReasonType> forTypeName(CharSequence requestedTypeName) {
            String requestedTypeNameString = requestedTypeName.toString();
            for (Known type : Known.values()) {
                if (!requestedTypeNameString.equals(type.typeName)) continue;
                return Optional.of(type);
            }
            return Optional.empty();
        }

        @Override
        public int length() {
            return this.typeName.length();
        }

        @Override
        public char charAt(int index) {
            return this.typeName.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.typeName.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.typeName;
        }
    }

    @Immutable
    public static final class Unknown
    implements ShutdownReasonType {
        private final String typeName;

        private Unknown(CharSequence theTypeName) {
            this.typeName = theTypeName.toString();
        }

        public static ShutdownReasonType of(CharSequence typeName) {
            return new Unknown(typeName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unknown unknown = (Unknown)o;
            return Objects.equals(this.typeName, unknown.typeName);
        }

        public int hashCode() {
            return Objects.hash(this.typeName);
        }

        @Override
        public int length() {
            return this.typeName.length();
        }

        @Override
        public char charAt(int index) {
            return this.typeName.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.typeName.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.typeName;
        }
    }
}

