/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.common.CommonCommandResponse;

@JsonParsableCommandResponse(type="common.responses:shutdown")
public final class ShutdownResponse
extends CommonCommandResponse<ShutdownResponse> {
    public static final String TYPE = "common.responses:shutdown";
    private static final JsonFieldDefinition<JsonValue> JSON_MESSAGE = JsonFactory.newJsonValueFieldDefinition((CharSequence)"message", (JsonFieldMarker[])new JsonFieldMarker[0]);
    private final JsonValue message;

    private ShutdownResponse(JsonValue message, DittoHeaders dittoHeaders) {
        super(TYPE, HttpStatusCode.OK, dittoHeaders);
        this.message = message;
    }

    public static ShutdownResponse of(Object message, DittoHeaders headers) {
        return new ShutdownResponse(JsonValue.of((Object)message), headers);
    }

    public static ShutdownResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new ShutdownResponse((JsonValue)jsonObject.getValueOrThrow(JSON_MESSAGE), dittoHeaders);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(JSON_MESSAGE, (Object)this.message);
    }

    public ShutdownResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ShutdownResponse(this.message, dittoHeaders);
    }

    public boolean equals(Object that) {
        if (super.equals(that) && that instanceof ShutdownResponse) {
            return Objects.equals(this.message, ((ShutdownResponse)((Object)that)).message);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.message);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", message=" + this.message + "]";
    }
}

