/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.common.purge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.id.DefaultEntityId;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.base.entity.type.EntityType;
import org.eclipse.ditto.model.base.entity.type.WithEntityType;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonParsableCommand;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.common.CommonCommand;

@JsonParsableCommand(typePrefix="common.commands:", name="purgeEntities")
@Immutable
public final class PurgeEntities
extends CommonCommand<PurgeEntities>
implements WithEntityType {
    static final String NAME = "purgeEntities";
    static final String TYPE_PREFIX = "common.commands:";
    public static final String TYPE = "common.commands:purgeEntities";
    private final EntityType entityType;
    private final List<EntityId> entityIds;

    private PurgeEntities(EntityType entityType, Collection<? extends EntityId> entityIds, DittoHeaders dittoHeaders) {
        super(TYPE, Command.Category.DELETE, dittoHeaders);
        this.entityType = entityType;
        this.entityIds = Collections.unmodifiableList(new ArrayList<EntityId>(entityIds));
    }

    public static PurgeEntities of(EntityType entityType, Collection<? extends EntityId> entityIds, DittoHeaders dittoHeaders) {
        return new PurgeEntities(PurgeEntities.validateEntityType(entityType), ConditionChecker.argumentNotEmpty(entityIds, (String)"entityIds"), dittoHeaders);
    }

    private static EntityType validateEntityType(EntityType entityType) {
        return (EntityType)ConditionChecker.checkNotNull((Object)entityType, (String)"entityType");
    }

    public static PurgeEntities fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (PurgeEntities)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            EntityType entityType = EntityType.of((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JsonFields.ENTITY_TYPE)));
            List entityIds = ((JsonArray)jsonObject.getValueOrThrow(JsonFields.ENTITY_IDS)).stream().map(JsonValue::asString).map(DefaultEntityId::of).collect(Collectors.toList());
            return PurgeEntities.of(entityType, entityIds, dittoHeaders);
        });
    }

    public static String getTopic(EntityType entityType) {
        return "common.commands:purgeEntities:" + PurgeEntities.validateEntityType(entityType);
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public List<EntityId> getEntityIds() {
        return this.entityIds;
    }

    public PurgeEntities setDittoHeaders(DittoHeaders dittoHeaders) {
        return PurgeEntities.of(this.entityType, this.entityIds, dittoHeaders);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PurgeEntities;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PurgeEntities that = (PurgeEntities)((Object)o);
        return Objects.equals(this.entityType, that.entityType) && Objects.equals(this.entityIds, that.entityIds);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> aPredicate) {
        Predicate predicate = schemaVersion.and(aPredicate);
        jsonObjectBuilder.set(JsonFields.ENTITY_TYPE, (Object)this.entityType.toString(), predicate);
        jsonObjectBuilder.set(JsonFields.ENTITY_IDS, (Object)JsonArray.of(this.entityIds), predicate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entityType, this.entityIds);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [" + super.toString() + ", entityType=" + this.entityType + ", entityIds=" + this.entityIds + "]";
    }

    @Immutable
    static final class JsonFields
    extends Command.JsonFields {
        public static final JsonFieldDefinition<String> ENTITY_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"entityType", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> ENTITY_IDS = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"entityIds", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        JsonFields() {
        }
    }
}

