/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.base.LiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyLiveCommandFactory;
import org.eclipse.ditto.signals.commands.live.query.QueryLiveCommandFactory;

@Immutable
public final class LiveCommandFactory {
    private static final int STRATEGIES_NUMBER = 26;
    private static final LiveCommandFactory INSTANCE = new LiveCommandFactory();
    private final Map<String, Function<Command, LiveCommand>> mappingStrategies = Collections.unmodifiableMap(LiveCommandFactory.initMappingStrategies());

    private LiveCommandFactory() {
    }

    private static Map<String, Function<Command, LiveCommand>> initMappingStrategies() {
        HashMap<String, Function<Command, LiveCommand>> result = new HashMap<String, Function<Command, LiveCommand>>(26);
        result.put("things.commands:createThing", ModifyLiveCommandFactory::createThing);
        result.put("things.commands:deleteAttribute", ModifyLiveCommandFactory::deleteAttribute);
        result.put("things.commands:deleteAttributes", ModifyLiveCommandFactory::deleteAttributes);
        result.put("things.commands:deleteFeature", ModifyLiveCommandFactory::deleteFeature);
        result.put("things.commands:deleteFeatureDefinition", ModifyLiveCommandFactory::deleteFeatureDefinition);
        result.put("things.commands:deleteFeatureProperties", ModifyLiveCommandFactory::deleteFeatureProperties);
        result.put("things.commands:deleteFeatureProperty", ModifyLiveCommandFactory::deleteFeatureProperty);
        result.put("things.commands:deleteFeatures", ModifyLiveCommandFactory::deleteFeatures);
        result.put("things.commands:deleteThing", ModifyLiveCommandFactory::deleteThing);
        result.put("things.commands:modifyAttribute", ModifyLiveCommandFactory::modifyAttribute);
        result.put("things.commands:modifyAttributes", ModifyLiveCommandFactory::modifyAttributes);
        result.put("things.commands:modifyFeature", ModifyLiveCommandFactory::modifyFeature);
        result.put("things.commands:modifyFeatureDefinition", ModifyLiveCommandFactory::modifyFeatureDefinition);
        result.put("things.commands:modifyFeatureProperties", ModifyLiveCommandFactory::modifyFeatureProperties);
        result.put("things.commands:modifyFeatureProperty", ModifyLiveCommandFactory::modifyFeatureProperty);
        result.put("things.commands:modifyFeatures", ModifyLiveCommandFactory::modifyFeatures);
        result.put("things.commands:modifyThing", ModifyLiveCommandFactory::modifyThing);
        result.put("things.commands:retrieveAttribute", QueryLiveCommandFactory::retrieveAttribute);
        result.put("things.commands:retrieveAttributes", QueryLiveCommandFactory::retrieveAttributes);
        result.put("things.commands:retrieveFeature", QueryLiveCommandFactory::retrieveFeature);
        result.put("things.commands:retrieveFeatureDefinition", QueryLiveCommandFactory::retrieveFeatureDefinition);
        result.put("things.commands:retrieveFeatureProperties", QueryLiveCommandFactory::retrieveFeatureProperties);
        result.put("things.commands:retrieveFeatureProperty", QueryLiveCommandFactory::retrieveFeatureProperty);
        result.put("things.commands:retrieveFeatures", QueryLiveCommandFactory::retrieveFeatures);
        result.put("things.commands:retrieveThing", QueryLiveCommandFactory::retrieveThing);
        result.put("things.commands:retrieveThings", QueryLiveCommandFactory::retrieveThings);
        return result;
    }

    @Nonnull
    public static LiveCommandFactory getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public LiveCommand getLiveCommand(@Nonnull Command<?> command) {
        ConditionChecker.checkNotNull(command, (String)"command");
        String commandType = command.getType();
        Function<Command, LiveCommand> commandToLiveCommand = this.mappingStrategies.get(commandType);
        if (null == commandToLiveCommand) {
            String msgTemplate = "No mapping strategy for command <{0}> available! The command type <{1}> is unknown!";
            throw new IllegalArgumentException(MessageFormat.format("No mapping strategy for command <{0}> available! The command type <{1}> is unknown!", command, commandType));
        }
        return commandToLiveCommand.apply(command);
    }
}

