/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.base;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.base.LiveCommand;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswerBuilder;

@ParametersAreNonnullByDefault
@Immutable
public abstract class AbstractLiveCommand<T extends LiveCommand<T, B>, B extends LiveCommandAnswerBuilder>
implements LiveCommand<T, B> {
    private final Command<?> command;

    protected AbstractLiveCommand(Command<?> command) {
        this.command = (Command)ConditionChecker.checkNotNull(command, (String)"command");
    }

    public JsonPointer getResourcePath() {
        return this.command.getResourcePath();
    }

    @Nonnull
    public String getManifest() {
        return this.command.getManifest();
    }

    public DittoHeaders getDittoHeaders() {
        return this.command.getDittoHeaders();
    }

    public String getType() {
        return this.command.getType();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        return this.command.toJson(schemaVersion, predicate);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractLiveCommand)) {
            return false;
        }
        AbstractLiveCommand that = (AbstractLiveCommand)o;
        return Objects.equals(this.getClass(), that.getClass()) && Objects.equals(this.command, that.command);
    }

    public final int hashCode() {
        return Objects.hash(this.command);
    }

    @Nonnull
    public String toString() {
        return "command=" + this.command;
    }
}

