/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.base;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswer;
import org.eclipse.ditto.signals.events.base.Event;

@Immutable
final class ImmutableLiveCommandAnswer
implements LiveCommandAnswer {
    private final CommandResponse<?> commandResponse;
    private final Event<?> event;

    private ImmutableLiveCommandAnswer(CommandResponse<?> theCommandResponse, Event<?> theEvent) {
        this.commandResponse = theCommandResponse;
        this.event = theEvent;
    }

    public static ImmutableLiveCommandAnswer newInstance(@Nullable CommandResponse<?> commandResponse, @Nullable Event<?> event) {
        return new ImmutableLiveCommandAnswer(commandResponse, event);
    }

    @Override
    @Nonnull
    public Optional<CommandResponse> getResponse() {
        return Optional.ofNullable(this.commandResponse);
    }

    @Override
    @Nonnull
    public Optional<Event> getEvent() {
        return Optional.ofNullable(this.event);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLiveCommandAnswer that = (ImmutableLiveCommandAnswer)o;
        return Objects.equals(this.commandResponse, that.commandResponse) && Objects.equals(this.event, that.event);
    }

    public int hashCode() {
        return Objects.hash(this.commandResponse, this.event);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [commandResponse=" + this.commandResponse + ", event=" + this.event + "]";
    }
}

