/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.live.base.LiveCommand;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswer;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswerFactory;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandResponseFactory;
import org.eclipse.ditto.signals.commands.live.base.LiveEventFactory;
import org.eclipse.ditto.signals.events.base.Event;

@ParametersAreNonnullByDefault
@NotThreadSafe
abstract class AbstractLiveCommandAnswerBuilder<C extends LiveCommand, R extends LiveCommandResponseFactory, E extends LiveEventFactory>
implements LiveCommandAnswerBuilder.ModifyCommandResponseStep<R, E>,
LiveCommandAnswerBuilder.EventStep<E>,
LiveCommandAnswerBuilder.BuildStep {
    protected final C command;
    private Function<R, CommandResponse<?>> createResponseFunction;
    private Function<E, Event<?>> createEventFunction;

    protected AbstractLiveCommandAnswerBuilder(C command) {
        this.command = (LiveCommand)ConditionChecker.checkNotNull(command, (String)"command");
        this.createResponseFunction = r -> null;
        this.createEventFunction = e -> null;
    }

    @Override
    public LiveCommandAnswerBuilder.EventStep<E> withResponse(Function<R, CommandResponse<?>> createResponseFunction) {
        this.createResponseFunction = (Function)ConditionChecker.checkNotNull(createResponseFunction, (String)"function for creating a command response");
        return this;
    }

    @Override
    public LiveCommandAnswerBuilder.EventStep<E> withoutResponse() {
        return this;
    }

    @Override
    public LiveCommandAnswerBuilder.BuildStep withEvent(Function<E, Event<?>> createEventFunction) {
        this.createEventFunction = (Function)ConditionChecker.checkNotNull(createEventFunction, (String)"function for creating an event");
        return this;
    }

    @Override
    public LiveCommandAnswerBuilder.BuildStep withoutEvent() {
        return this;
    }

    @Override
    public LiveCommandAnswer build() {
        CommandResponse commandResponse = this.doCreateResponse(this.createResponseFunction);
        Event event = this.doCreateEvent(this.createEventFunction);
        return LiveCommandAnswerFactory.newLiveCommandAnswer(commandResponse, event);
    }

    @Nullable
    protected abstract CommandResponse doCreateResponse(Function<R, CommandResponse<?>> var1);

    @Nullable
    protected abstract Event doCreateEvent(Function<E, Event<?>> var1);
}

