/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.CreateThingLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.CreateThingLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.CreateThingLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.CreateThing;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@ParametersAreNonnullByDefault
@Immutable
final class CreateThingLiveCommandImpl
extends AbstractModifyLiveCommand<CreateThingLiveCommand, CreateThingLiveCommandAnswerBuilder>
implements CreateThingLiveCommand {
    private final Thing thing;

    private CreateThingLiveCommandImpl(CreateThing command) {
        super((ThingModifyCommand<?>)command);
        this.thing = command.getThing();
    }

    @Nonnull
    public static CreateThingLiveCommand of(Command<?> command) {
        return new CreateThingLiveCommandImpl((CreateThing)command);
    }

    @Override
    public ThingId getThingEntityId() {
        return this.thing.getEntityId().orElse(null);
    }

    @Override
    public Thing getThing() {
        return this.thing;
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    public CreateThingLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return CreateThingLiveCommandImpl.of(CreateThing.of((Thing)this.thing, null, (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public CreateThingLiveCommandAnswerBuilder answer() {
        return CreateThingLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

