/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.DeleteAttributeLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.DeleteAttributeLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.DeleteAttributeLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.DeleteAttribute;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@ParametersAreNonnullByDefault
@Immutable
final class DeleteAttributeLiveCommandImpl
extends AbstractModifyLiveCommand<DeleteAttributeLiveCommand, DeleteAttributeLiveCommandAnswerBuilder>
implements DeleteAttributeLiveCommand {
    private final JsonPointer attributePointer;

    private DeleteAttributeLiveCommandImpl(DeleteAttribute command) {
        super((ThingModifyCommand<?>)command);
        this.attributePointer = command.getAttributePointer();
    }

    @Nonnull
    public static DeleteAttributeLiveCommandImpl of(Command<?> command) {
        return new DeleteAttributeLiveCommandImpl((DeleteAttribute)command);
    }

    @Override
    public JsonPointer getAttributePointer() {
        return this.attributePointer;
    }

    public Command.Category getCategory() {
        return Command.Category.DELETE;
    }

    public DeleteAttributeLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return new DeleteAttributeLiveCommandImpl(DeleteAttribute.of((ThingId)this.getThingEntityId(), (JsonPointer)this.attributePointer, (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public DeleteAttributeLiveCommandAnswerBuilder answer() {
        return DeleteAttributeLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

