/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.live.modify.AbstractLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.DeleteAttributesLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.DeleteAttributesLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.things.ThingErrorResponse;
import org.eclipse.ditto.signals.commands.things.exceptions.AttributesNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.AttributesNotModifiableException;
import org.eclipse.ditto.signals.commands.things.modify.DeleteAttributesResponse;
import org.eclipse.ditto.signals.events.base.Event;
import org.eclipse.ditto.signals.events.things.AttributesDeleted;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class DeleteAttributesLiveCommandAnswerBuilderImpl
extends AbstractLiveCommandAnswerBuilder<DeleteAttributesLiveCommand, DeleteAttributesLiveCommandAnswerBuilder.ResponseFactory, DeleteAttributesLiveCommandAnswerBuilder.EventFactory>
implements DeleteAttributesLiveCommandAnswerBuilder {
    private DeleteAttributesLiveCommandAnswerBuilderImpl(DeleteAttributesLiveCommand command) {
        super(command);
    }

    public static DeleteAttributesLiveCommandAnswerBuilderImpl newInstance(DeleteAttributesLiveCommand command) {
        return new DeleteAttributesLiveCommandAnswerBuilderImpl(command);
    }

    @Override
    protected CommandResponse doCreateResponse(Function<DeleteAttributesLiveCommandAnswerBuilder.ResponseFactory, CommandResponse<?>> createResponseFunction) {
        return createResponseFunction.apply(new ResponseFactoryImpl());
    }

    @Override
    protected Event doCreateEvent(Function<DeleteAttributesLiveCommandAnswerBuilder.EventFactory, Event<?>> createEventFunction) {
        return createEventFunction.apply(new EventFactoryImpl());
    }

    @Immutable
    private final class EventFactoryImpl
    implements DeleteAttributesLiveCommandAnswerBuilder.EventFactory {
        private EventFactoryImpl() {
        }

        @Override
        @Nonnull
        public AttributesDeleted deleted() {
            return AttributesDeleted.of((ThingId)((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getThingEntityId(), (long)-1L, (Instant)Instant.now(), (DittoHeaders)((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders());
        }
    }

    @Immutable
    private final class ResponseFactoryImpl
    implements DeleteAttributesLiveCommandAnswerBuilder.ResponseFactory {
        private ResponseFactoryImpl() {
        }

        @Override
        @Nonnull
        public DeleteAttributesResponse deleted() {
            return DeleteAttributesResponse.of((ThingId)((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getThingEntityId(), (DittoHeaders)((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders());
        }

        @Override
        @Nonnull
        public ThingErrorResponse attributesNotAccessibleError() {
            DittoRuntimeException exception = AttributesNotAccessibleException.newBuilder((ThingId)((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getThingEntityId()).dittoHeaders(((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders()).build();
            return this.errorResponse(((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getThingEntityId(), exception);
        }

        @Override
        @Nonnull
        public ThingErrorResponse attributesNotModifiableError() {
            DittoRuntimeException exception = AttributesNotModifiableException.newBuilder((ThingId)((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getThingEntityId()).dittoHeaders(((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders()).build();
            return this.errorResponse(((DeleteAttributesLiveCommand)DeleteAttributesLiveCommandAnswerBuilderImpl.this.command).getThingEntityId(), exception);
        }
    }
}

