/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.DeleteFeaturePropertyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.DeleteFeaturePropertyLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.DeleteFeaturePropertyLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.DeleteFeatureProperty;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@Immutable
final class DeleteFeaturePropertyLiveCommandImpl
extends AbstractModifyLiveCommand<DeleteFeaturePropertyLiveCommand, DeleteFeaturePropertyLiveCommandAnswerBuilder>
implements DeleteFeaturePropertyLiveCommand {
    private final String featureId;
    private final JsonPointer propertyPointer;

    private DeleteFeaturePropertyLiveCommandImpl(DeleteFeatureProperty command) {
        super((ThingModifyCommand<?>)command);
        this.featureId = command.getFeatureId();
        this.propertyPointer = command.getPropertyPointer();
    }

    @Nonnull
    public static DeleteFeaturePropertyLiveCommandImpl of(Command<?> command) {
        return new DeleteFeaturePropertyLiveCommandImpl((DeleteFeatureProperty)command);
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    public JsonPointer getPropertyPointer() {
        return this.propertyPointer;
    }

    public Command.Category getCategory() {
        return Command.Category.DELETE;
    }

    public DeleteFeaturePropertyLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return new DeleteFeaturePropertyLiveCommandImpl(DeleteFeatureProperty.of((ThingId)this.getThingEntityId(), (String)this.getFeatureId(), (JsonPointer)this.getPropertyPointer(), (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public DeleteFeaturePropertyLiveCommandAnswerBuilder answer() {
        return DeleteFeaturePropertyLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

