/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyAttributeLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyAttributeLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.ModifyAttributeLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.ModifyAttribute;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@Immutable
final class ModifyAttributeLiveCommandImpl
extends AbstractModifyLiveCommand<ModifyAttributeLiveCommand, ModifyAttributeLiveCommandAnswerBuilder>
implements ModifyAttributeLiveCommand {
    private final JsonPointer attributePointer;
    private final JsonValue attributeValue;

    private ModifyAttributeLiveCommandImpl(ModifyAttribute command) {
        super((ThingModifyCommand<?>)command);
        this.attributePointer = command.getAttributePointer();
        this.attributeValue = command.getAttributeValue();
    }

    @Nonnull
    public static ModifyAttributeLiveCommandImpl of(Command<?> command) {
        return new ModifyAttributeLiveCommandImpl((ModifyAttribute)command);
    }

    @Override
    @Nonnull
    public JsonPointer getAttributePointer() {
        return this.attributePointer;
    }

    @Override
    @Nonnull
    public JsonValue getAttributeValue() {
        return this.attributeValue;
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    public ModifyAttributeLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ModifyAttributeLiveCommandImpl(ModifyAttribute.of((ThingId)this.getThingEntityId(), (JsonPointer)this.getAttributePointer(), (JsonValue)this.getAttributeValue(), (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public ModifyAttributeLiveCommandAnswerBuilder answer() {
        return ModifyAttributeLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

