/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeatureLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeatureLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeatureLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.ModifyFeature;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@ParametersAreNonnullByDefault
@Immutable
final class ModifyFeatureLiveCommandImpl
extends AbstractModifyLiveCommand<ModifyFeatureLiveCommand, ModifyFeatureLiveCommandAnswerBuilder>
implements ModifyFeatureLiveCommand {
    private final Feature feature;

    private ModifyFeatureLiveCommandImpl(ModifyFeature command) {
        super((ThingModifyCommand<?>)command);
        this.feature = command.getFeature();
    }

    @Nonnull
    public static ModifyFeatureLiveCommandImpl of(Command<?> command) {
        return new ModifyFeatureLiveCommandImpl((ModifyFeature)command);
    }

    public String getFeatureId() {
        return this.feature.getId();
    }

    @Override
    @Nonnull
    public Feature getFeature() {
        return this.feature;
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    public ModifyFeatureLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ModifyFeatureLiveCommandImpl(ModifyFeature.of((ThingId)this.getThingEntityId(), (Feature)this.getFeature(), (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public ModifyFeatureLiveCommandAnswerBuilder answer() {
        return ModifyFeatureLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

