/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeaturePropertiesLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeaturePropertiesLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeaturePropertiesLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.ModifyFeatureProperties;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@ParametersAreNonnullByDefault
@Immutable
final class ModifyFeaturePropertiesLiveCommandImpl
extends AbstractModifyLiveCommand<ModifyFeaturePropertiesLiveCommand, ModifyFeaturePropertiesLiveCommandAnswerBuilder>
implements ModifyFeaturePropertiesLiveCommand {
    private final String featureId;
    private final FeatureProperties featureProperties;

    private ModifyFeaturePropertiesLiveCommandImpl(ModifyFeatureProperties command) {
        super((ThingModifyCommand<?>)command);
        this.featureId = command.getFeatureId();
        this.featureProperties = command.getProperties();
    }

    @Nonnull
    public static ModifyFeaturePropertiesLiveCommandImpl of(Command<?> command) {
        return new ModifyFeaturePropertiesLiveCommandImpl((ModifyFeatureProperties)command);
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    @Nonnull
    public FeatureProperties getProperties() {
        return this.featureProperties;
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    public ModifyFeaturePropertiesLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ModifyFeaturePropertiesLiveCommandImpl(ModifyFeatureProperties.of((ThingId)this.getThingEntityId(), (String)this.getFeatureId(), (FeatureProperties)this.getProperties(), (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public ModifyFeaturePropertiesLiveCommandAnswerBuilder answer() {
        return ModifyFeaturePropertiesLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

