/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeaturePropertyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeaturePropertyLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.ModifyFeaturePropertyLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.ModifyFeatureProperty;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@ParametersAreNonnullByDefault
@Immutable
final class ModifyFeaturePropertyLiveCommandImpl
extends AbstractModifyLiveCommand<ModifyFeaturePropertyLiveCommand, ModifyFeaturePropertyLiveCommandAnswerBuilder>
implements ModifyFeaturePropertyLiveCommand {
    private final String featureId;
    private final JsonPointer propertyPointer;
    private final JsonValue propertyValue;

    private ModifyFeaturePropertyLiveCommandImpl(ModifyFeatureProperty command) {
        super((ThingModifyCommand<?>)command);
        this.featureId = command.getFeatureId();
        this.propertyPointer = command.getPropertyPointer();
        this.propertyValue = command.getPropertyValue();
    }

    @Nonnull
    public static ModifyFeaturePropertyLiveCommandImpl of(Command<?> command) {
        return new ModifyFeaturePropertyLiveCommandImpl((ModifyFeatureProperty)command);
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    @Nonnull
    public JsonPointer getPropertyPointer() {
        return this.propertyPointer;
    }

    @Override
    @Nonnull
    public JsonValue getPropertyValue() {
        return this.propertyValue;
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    public ModifyFeaturePropertyLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ModifyFeaturePropertyLiveCommandImpl(ModifyFeatureProperty.of((ThingId)this.getThingEntityId(), (String)this.getFeatureId(), (JsonPointer)this.getPropertyPointer(), (JsonValue)this.getPropertyValue(), (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public ModifyFeaturePropertyLiveCommandAnswerBuilder answer() {
        return ModifyFeaturePropertyLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

