/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.live.modify.AbstractLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.ModifyThingLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyThingLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.things.ThingErrorResponse;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingNotModifiableException;
import org.eclipse.ditto.signals.commands.things.modify.ModifyThingResponse;
import org.eclipse.ditto.signals.events.base.Event;
import org.eclipse.ditto.signals.events.things.ThingCreated;
import org.eclipse.ditto.signals.events.things.ThingModified;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class ModifyThingLiveCommandAnswerBuilderImpl
extends AbstractLiveCommandAnswerBuilder<ModifyThingLiveCommand, ModifyThingLiveCommandAnswerBuilder.ResponseFactory, ModifyThingLiveCommandAnswerBuilder.EventFactory>
implements ModifyThingLiveCommandAnswerBuilder {
    private ModifyThingLiveCommandAnswerBuilderImpl(ModifyThingLiveCommand command) {
        super(command);
    }

    public static ModifyThingLiveCommandAnswerBuilderImpl newInstance(ModifyThingLiveCommand command) {
        ConditionChecker.checkNotNull((Object)command, (String)"command");
        return new ModifyThingLiveCommandAnswerBuilderImpl(command);
    }

    @Override
    protected CommandResponse doCreateResponse(Function<ModifyThingLiveCommandAnswerBuilder.ResponseFactory, CommandResponse<?>> createResponseFunction) {
        return createResponseFunction.apply(new ResponseFactoryImpl());
    }

    @Override
    protected Event doCreateEvent(Function<ModifyThingLiveCommandAnswerBuilder.EventFactory, Event<?>> createEventFunction) {
        return createEventFunction.apply(new EventFactoryImpl());
    }

    @Immutable
    private final class EventFactoryImpl
    implements ModifyThingLiveCommandAnswerBuilder.EventFactory {
        private EventFactoryImpl() {
        }

        @Override
        @Nonnull
        public ThingCreated created() {
            return ThingCreated.of((Thing)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThing(), (long)-1L, (Instant)Instant.now(), (DittoHeaders)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders());
        }

        @Override
        @Nonnull
        public ThingModified modified() {
            return ThingModified.of((Thing)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThing(), (long)-1L, (Instant)Instant.now(), (DittoHeaders)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders());
        }
    }

    @Immutable
    private final class ResponseFactoryImpl
    implements ModifyThingLiveCommandAnswerBuilder.ResponseFactory {
        private ResponseFactoryImpl() {
        }

        @Override
        @Nonnull
        public ModifyThingResponse created() {
            return ModifyThingResponse.created((Thing)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThing(), (DittoHeaders)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders());
        }

        @Override
        @Nonnull
        public ModifyThingResponse modified() {
            return ModifyThingResponse.modified((ThingId)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThingEntityId(), (DittoHeaders)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders());
        }

        @Override
        @Nonnull
        public ThingErrorResponse thingNotAccessibleError() {
            return this.errorResponse(((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThingEntityId(), ThingNotAccessibleException.newBuilder((ThingId)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThingEntityId()).dittoHeaders(((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders()).build());
        }

        @Override
        @Nonnull
        public ThingErrorResponse thingNotModifiableError() {
            return this.errorResponse(((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThingEntityId(), ThingNotModifiableException.newBuilder((ThingId)((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getThingEntityId()).dittoHeaders(((ModifyThingLiveCommand)ModifyThingLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders()).build());
        }
    }
}

