/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.modify;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.modify.AbstractModifyLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyThingLiveCommand;
import org.eclipse.ditto.signals.commands.live.modify.ModifyThingLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.modify.ModifyThingLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.modify.ModifyThing;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

@ParametersAreNonnullByDefault
@Immutable
final class ModifyThingLiveCommandImpl
extends AbstractModifyLiveCommand<ModifyThingLiveCommand, ModifyThingLiveCommandAnswerBuilder>
implements ModifyThingLiveCommand {
    private final Thing thing;

    private ModifyThingLiveCommandImpl(ModifyThing command) {
        super((ThingModifyCommand<?>)command);
        this.thing = command.getThing();
    }

    @Nonnull
    public static ModifyThingLiveCommandImpl of(Command<?> command) {
        return new ModifyThingLiveCommandImpl((ModifyThing)command);
    }

    @Override
    @Nonnull
    public Thing getThing() {
        return this.thing;
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    public ModifyThingLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return new ModifyThingLiveCommandImpl(ModifyThing.of((ThingId)this.getThingEntityId(), (Thing)this.getThing(), null, (DittoHeaders)dittoHeaders));
    }

    public boolean changesAuthorization() {
        return false;
    }

    @Override
    @Nonnull
    public ModifyThingLiveCommandAnswerBuilder answer() {
        return ModifyThingLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

