/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.query;

import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.live.base.LiveCommand;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswer;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandAnswerFactory;
import org.eclipse.ditto.signals.commands.live.base.LiveCommandResponseFactory;

@ParametersAreNonnullByDefault
@NotThreadSafe
abstract class AbstractLiveCommandAnswerBuilder<C extends LiveCommand, R extends LiveCommandResponseFactory>
implements LiveCommandAnswerBuilder.QueryCommandResponseStep<R>,
LiveCommandAnswerBuilder.BuildStep {
    protected final C command;
    private Function<R, CommandResponse<?>> createResponseFunction;

    protected AbstractLiveCommandAnswerBuilder(C command) {
        this.command = (LiveCommand)ConditionChecker.checkNotNull(command, (String)"command");
        this.createResponseFunction = r -> null;
    }

    @Override
    public LiveCommandAnswerBuilder.BuildStep withResponse(Function<R, CommandResponse<?>> createResponseFunction) {
        this.createResponseFunction = (Function)ConditionChecker.checkNotNull(createResponseFunction, (String)"function for creating a command response");
        return this;
    }

    @Override
    public LiveCommandAnswerBuilder.BuildStep withoutResponse() {
        return this;
    }

    @Override
    public LiveCommandAnswer build() {
        CommandResponse commandResponse = this.doCreateResponse(this.createResponseFunction);
        return LiveCommandAnswerFactory.newLiveCommandAnswer(commandResponse);
    }

    protected abstract CommandResponse doCreateResponse(Function<R, CommandResponse<?>> var1);
}

