/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.query;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.query.AbstractQueryLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveAttributeLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveAttributeLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.query.RetrieveAttributeLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.query.RetrieveAttribute;
import org.eclipse.ditto.signals.commands.things.query.ThingQueryCommand;

@ParametersAreNonnullByDefault
@Immutable
final class RetrieveAttributeLiveCommandImpl
extends AbstractQueryLiveCommand<RetrieveAttributeLiveCommand, RetrieveAttributeLiveCommandAnswerBuilder>
implements RetrieveAttributeLiveCommand {
    private final JsonPointer attributePointer;

    private RetrieveAttributeLiveCommandImpl(RetrieveAttribute command) {
        super((ThingQueryCommand<?>)command);
        this.attributePointer = command.getAttributePointer();
    }

    @Nonnull
    public static RetrieveAttributeLiveCommandImpl of(Command<?> command) {
        return new RetrieveAttributeLiveCommandImpl((RetrieveAttribute)command);
    }

    @Override
    @Nonnull
    public JsonPointer getAttributePointer() {
        return this.attributePointer;
    }

    public RetrieveAttributeLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveAttributeLiveCommandImpl.of(RetrieveAttribute.of((ThingId)this.getThingEntityId(), (JsonPointer)this.getAttributePointer(), (DittoHeaders)dittoHeaders));
    }

    @Override
    @Nonnull
    public RetrieveAttributeLiveCommandAnswerBuilder answer() {
        return RetrieveAttributeLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

