/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.query;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.query.AbstractQueryLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveFeatureLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveFeatureLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.query.RetrieveFeatureLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.query.RetrieveFeature;
import org.eclipse.ditto.signals.commands.things.query.ThingQueryCommand;

@ParametersAreNonnullByDefault
@Immutable
final class RetrieveFeatureLiveCommandImpl
extends AbstractQueryLiveCommand<RetrieveFeatureLiveCommand, RetrieveFeatureLiveCommandAnswerBuilder>
implements RetrieveFeatureLiveCommand {
    private final String featureId;

    private RetrieveFeatureLiveCommandImpl(RetrieveFeature command) {
        super((ThingQueryCommand<?>)command);
        this.featureId = command.getFeatureId();
    }

    @Nonnull
    public static RetrieveFeatureLiveCommandImpl of(Command<?> command) {
        return new RetrieveFeatureLiveCommandImpl((RetrieveFeature)command);
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public RetrieveFeatureLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveFeatureLiveCommandImpl.of(RetrieveFeature.of((ThingId)this.getThingEntityId(), (String)this.getFeatureId(), (JsonFieldSelector)this.getSelectedFields().orElse(null), (DittoHeaders)dittoHeaders));
    }

    @Override
    @Nonnull
    public RetrieveFeatureLiveCommandAnswerBuilder answer() {
        return RetrieveFeatureLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

