/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.query;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.query.AbstractQueryLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveFeaturePropertyLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveFeaturePropertyLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.query.RetrieveFeaturePropertyLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.query.RetrieveFeatureProperty;
import org.eclipse.ditto.signals.commands.things.query.ThingQueryCommand;

@ParametersAreNonnullByDefault
@Immutable
final class RetrieveFeaturePropertyLiveCommandImpl
extends AbstractQueryLiveCommand<RetrieveFeaturePropertyLiveCommand, RetrieveFeaturePropertyLiveCommandAnswerBuilder>
implements RetrieveFeaturePropertyLiveCommand {
    private final String featureId;
    private final JsonPointer propertyPointer;

    private RetrieveFeaturePropertyLiveCommandImpl(RetrieveFeatureProperty command) {
        super((ThingQueryCommand<?>)command);
        this.featureId = command.getFeatureId();
        this.propertyPointer = command.getPropertyPointer();
    }

    @Nonnull
    public static RetrieveFeaturePropertyLiveCommandImpl of(Command<?> command) {
        return new RetrieveFeaturePropertyLiveCommandImpl((RetrieveFeatureProperty)command);
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    @Nonnull
    public JsonPointer getPropertyPointer() {
        return this.propertyPointer;
    }

    public RetrieveFeaturePropertyLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveFeaturePropertyLiveCommandImpl.of(RetrieveFeatureProperty.of((ThingId)this.getThingEntityId(), (String)this.getFeatureId(), (JsonPointer)this.getPropertyPointer(), (DittoHeaders)dittoHeaders));
    }

    @Override
    @Nonnull
    public RetrieveFeaturePropertyLiveCommandAnswerBuilder answer() {
        return RetrieveFeaturePropertyLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + "]";
    }
}

