/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.query;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.live.query.AbstractLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.query.RetrieveThingsLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveThingsLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.things.query.RetrieveThingsResponse;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class RetrieveThingsLiveCommandAnswerBuilderImpl
extends AbstractLiveCommandAnswerBuilder<RetrieveThingsLiveCommand, RetrieveThingsLiveCommandAnswerBuilder.ResponseFactory>
implements RetrieveThingsLiveCommandAnswerBuilder {
    private RetrieveThingsLiveCommandAnswerBuilderImpl(RetrieveThingsLiveCommand command) {
        super(command);
    }

    public static RetrieveThingsLiveCommandAnswerBuilderImpl newInstance(RetrieveThingsLiveCommand command) {
        return new RetrieveThingsLiveCommandAnswerBuilderImpl(command);
    }

    @Override
    protected CommandResponse doCreateResponse(Function<RetrieveThingsLiveCommandAnswerBuilder.ResponseFactory, CommandResponse<?>> createResponseFunction) {
        return createResponseFunction.apply(new ResponseFactoryImpl());
    }

    @ParametersAreNonnullByDefault
    @Immutable
    private final class ResponseFactoryImpl
    implements RetrieveThingsLiveCommandAnswerBuilder.ResponseFactory {
        private ResponseFactoryImpl() {
        }

        @Override
        @Nonnull
        public RetrieveThingsResponse retrieved(List<Thing> things, Predicate<JsonField> predicate) {
            DittoHeaders dittoHeaders = ((RetrieveThingsLiveCommand)RetrieveThingsLiveCommandAnswerBuilderImpl.this.command).getDittoHeaders();
            String namespace = ((RetrieveThingsLiveCommand)RetrieveThingsLiveCommandAnswerBuilderImpl.this.command).getNamespace().orElse(null);
            Function<JsonFieldSelector, RetrieveThingsResponse> fieldSelectorToResponse = fieldSelector -> RetrieveThingsResponse.of((List)things, (JsonFieldSelector)fieldSelector, (Predicate)predicate, (String)namespace, (DittoHeaders)dittoHeaders);
            return ((RetrieveThingsLiveCommand)RetrieveThingsLiveCommandAnswerBuilderImpl.this.command).getSelectedFields().map(fieldSelectorToResponse).orElse(RetrieveThingsResponse.of(things, predicate, (String)namespace, (DittoHeaders)dittoHeaders));
        }

        @Override
        @Nonnull
        public RetrieveThingsResponse retrieved(List<Thing> things) {
            return this.retrieved(things, jsonField -> true);
        }
    }
}

