/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.live.query;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.live.query.AbstractQueryLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveThingsLiveCommand;
import org.eclipse.ditto.signals.commands.live.query.RetrieveThingsLiveCommandAnswerBuilder;
import org.eclipse.ditto.signals.commands.live.query.RetrieveThingsLiveCommandAnswerBuilderImpl;
import org.eclipse.ditto.signals.commands.things.query.RetrieveThings;
import org.eclipse.ditto.signals.commands.things.query.ThingQueryCommand;

@ParametersAreNonnullByDefault
@Immutable
final class RetrieveThingsLiveCommandImpl
extends AbstractQueryLiveCommand<RetrieveThingsLiveCommand, RetrieveThingsLiveCommandAnswerBuilder>
implements RetrieveThingsLiveCommand {
    private final List<ThingId> thingIds;
    @Nullable
    private final String namespace;

    private RetrieveThingsLiveCommandImpl(RetrieveThings command) {
        super((ThingQueryCommand<?>)command);
        this.thingIds = command.getThingEntityIds();
        this.namespace = command.getNamespace().orElse(null);
    }

    @Nonnull
    public static RetrieveThingsLiveCommandImpl of(Command<?> command) {
        return new RetrieveThingsLiveCommandImpl((RetrieveThings)command);
    }

    @Override
    @Nonnull
    public List<ThingId> getThingEntityIds() {
        return this.thingIds;
    }

    @Nonnull
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public RetrieveThingsLiveCommand setDittoHeaders(DittoHeaders dittoHeaders) {
        RetrieveThings retrieveThingsCommand = RetrieveThings.getBuilder(this.getThingEntityIds()).dittoHeaders(dittoHeaders).selectedFields((JsonFieldSelector)this.getSelectedFields().orElse(null)).build();
        return RetrieveThingsLiveCommandImpl.of(retrieveThingsCommand);
    }

    @Override
    @Nonnull
    public RetrieveThingsLiveCommandAnswerBuilder answer() {
        return RetrieveThingsLiveCommandAnswerBuilderImpl.newInstance(this);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + super.toString() + ", namespace=" + this.namespace + "]";
    }
}

