/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.messages.MessageBuilder;
import org.eclipse.ditto.model.messages.MessageHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.commands.messages.MessageCommandResponse;
import org.eclipse.ditto.signals.commands.messages.MessagePayloadSerializer;

abstract class AbstractMessageCommandResponse<T, C extends AbstractMessageCommandResponse>
extends AbstractCommandResponse<C>
implements MessageCommandResponse<T, C> {
    private final ThingId thingId;
    private final Message<T> message;

    AbstractMessageCommandResponse(String type, ThingId thingId, Message<T> message, HttpStatusCode httpStatusCode, DittoHeaders dittoHeaders) {
        super(type, httpStatusCode, dittoHeaders);
        this.thingId = Objects.requireNonNull(thingId, "The thingId cannot be null.");
        this.message = Objects.requireNonNull(message, "The message cannot be null.");
    }

    public ThingId getThingEntityId() {
        return this.thingId;
    }

    @Override
    public Message<T> getMessage() {
        return this.message;
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(MessageCommandResponse.JsonFields.JSON_THING_ID, (Object)this.getThingEntityId().toString(), predicate);
        JsonObjectBuilder messageBuilder = JsonFactory.newObjectBuilder();
        JsonObject messageHeadersObject = (JsonObject)this.message.getHeaders().toJson();
        messageBuilder.set(MessageCommandResponse.JsonFields.JSON_MESSAGE_HEADERS, (Object)messageHeadersObject, predicate);
        MessagePayloadSerializer.serialize(this.message, messageBuilder, predicate);
        JsonObject messageObject = messageBuilder.build();
        jsonObjectBuilder.set(MessageCommandResponse.JsonFields.JSON_MESSAGE, (Object)messageObject, predicate);
    }

    protected static <T> Message<T> deserializeMessageFromJson(JsonObject jsonObject) {
        JsonObject messageObject = (JsonObject)jsonObject.getValueOrThrow(MessageCommandResponse.JsonFields.JSON_MESSAGE);
        JsonObject messageHeadersObject = messageObject.getValue(MessageCommandResponse.JsonFields.JSON_MESSAGE_HEADERS).filter(JsonValue::isObject).map(JsonValue::asObject).orElseThrow(() -> (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName((CharSequence)MessageCommandResponse.JsonFields.JSON_MESSAGE_HEADERS.getPointer().toString()).build());
        Optional messagePayloadOptional = messageObject.getValue(MessageCommand.JsonFields.JSON_MESSAGE_PAYLOAD);
        MessageHeaders messageHeaders = MessageHeaders.of((JsonObject)messageHeadersObject);
        MessageBuilder messageBuilder = Message.newBuilder((MessageHeaders)messageHeaders);
        MessagePayloadSerializer.deserialize(messagePayloadOptional, messageBuilder, messageHeaders);
        return messageBuilder.build();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.thingId, this.message);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMessageCommandResponse other = (AbstractMessageCommandResponse)obj;
        return other.canEqual(this) && Objects.equals(this.thingId, other.thingId) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractMessageCommandResponse;
    }

    public String toString() {
        return "thingId=" + this.thingId + ", message=" + this.message;
    }

    @Override
    public abstract C setDittoHeaders(DittoHeaders var1);
}

