/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.messages.MessageDirection;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.WithThingId;
import org.eclipse.ditto.signals.base.WithId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandResponse;

public interface MessageCommandResponse<T, C extends MessageCommandResponse>
extends CommandResponse<C>,
WithId,
WithThingId {
    public static final String TYPE_PREFIX = "messages.responses:";

    public Message<T> getMessage();

    default public String getMessageType() {
        return this.getName();
    }

    default public ThingId getEntityId() {
        return this.getThingEntityId();
    }

    default public String getResourceType() {
        return "message";
    }

    public C setDittoHeaders(DittoHeaders var1);

    default public JsonPointer getResourcePath() {
        Message<T> message = this.getMessage();
        String box = message.getDirection() == MessageDirection.TO ? "inbox" : "outbox";
        JsonPointer pathSuffix = JsonFactory.newPointer((JsonKey)JsonKey.of((CharSequence)box), (JsonKey[])new JsonKey[]{JsonKey.of((CharSequence)"messages"), JsonKey.of((CharSequence)message.getSubject())});
        JsonPointer path = message.getFeatureId().map(fId -> JsonFactory.newPointer((JsonKey)JsonKey.of((CharSequence)"features"), (JsonKey[])new JsonKey[]{JsonKey.of((CharSequence)fId)})).orElse(JsonPointer.empty());
        return path.append(pathSuffix);
    }

    public static class JsonFields
    extends Command.JsonFields {
        public static final JsonFieldDefinition<String> JSON_THING_ID = JsonFactory.newStringFieldDefinition((CharSequence)"thingId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> JSON_MESSAGE = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"message", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> JSON_MESSAGE_HEADERS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"headers", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> JSON_MESSAGE_PAYLOAD = JsonFactory.newStringFieldDefinition((CharSequence)"payload", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    }
}

