/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.messages.MessagePayloadSizeTooLargeException;
import org.eclipse.ditto.signals.commands.base.AbstractCommandSizeValidator;

public final class MessageCommandSizeValidator
extends AbstractCommandSizeValidator<MessagePayloadSizeTooLargeException> {
    public static final String DITTO_LIMITS_MESSAGES_MAX_SIZE_BYTES = "ditto.limits.messages.max-size";
    @Nullable
    private static MessageCommandSizeValidator instance;

    private MessageCommandSizeValidator(@Nullable Long maxSize) {
        super(maxSize);
    }

    protected MessagePayloadSizeTooLargeException newInvalidSizeException(long maxSize, long actualSize, DittoHeaders headers) {
        return (MessagePayloadSizeTooLargeException)MessagePayloadSizeTooLargeException.newBuilder((long)actualSize, (long)maxSize).dittoHeaders(headers).build();
    }

    public static MessageCommandSizeValidator getInstance() {
        if (null == instance) {
            long maxSize = Long.parseLong(System.getProperty(DITTO_LIMITS_MESSAGES_MAX_SIZE_BYTES, "-1"));
            instance = maxSize > 0L ? new MessageCommandSizeValidator(maxSize) : new MessageCommandSizeValidator(null);
        }
        return instance;
    }
}

