/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommand;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.messages.AbstractMessageCommand;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;

@JsonParsableCommand(typePrefix="messages.commands:", name="claimMessage")
public final class SendClaimMessage<T>
extends AbstractMessageCommand<T, SendClaimMessage> {
    public static final String NAME = "claimMessage";
    public static final String TYPE = "messages.commands:claimMessage";

    private SendClaimMessage(ThingId thingId, Message<T> message, DittoHeaders dittoHeaders) {
        super(TYPE, thingId, message, dittoHeaders);
    }

    @Override
    public SendClaimMessage setDittoHeaders(DittoHeaders dittoHeaders) {
        return SendClaimMessage.of(this.getThingEntityId(), this.getMessage(), dittoHeaders);
    }

    @Deprecated
    public static <T> SendClaimMessage<T> of(String thingId, Message<T> message, DittoHeaders dittoHeaders) {
        return SendClaimMessage.of(ThingId.of((CharSequence)thingId), message, dittoHeaders);
    }

    public static <T> SendClaimMessage<T> of(ThingId thingId, Message<T> message, DittoHeaders dittoHeaders) {
        return new SendClaimMessage<T>(thingId, message, dittoHeaders);
    }

    public static <T> SendClaimMessage<T> fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return SendClaimMessage.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static <T> SendClaimMessage<T> fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SendClaimMessage)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String extractedThingId = (String)jsonObject.getValueOrThrow(MessageCommand.JsonFields.JSON_THING_ID);
            ThingId thingId = ThingId.of((CharSequence)extractedThingId);
            Message message = SendClaimMessage.deserializeMessageFromJson(jsonObject);
            return SendClaimMessage.of(thingId, message, dittoHeaders);
        });
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SendClaimMessage;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + "]";
    }
}

