/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.messages.AbstractMessageCommandResponse;
import org.eclipse.ditto.signals.commands.messages.MessageCommandResponse;

@JsonParsableCommandResponse(type="messages.responses:claimResponseMessage")
public final class SendClaimMessageResponse<T>
extends AbstractMessageCommandResponse<T, SendClaimMessageResponse> {
    public static final String NAME = "claimResponseMessage";
    public static final String TYPE = "messages.responses:claimResponseMessage";

    private SendClaimMessageResponse(ThingId thingId, Message<T> message, HttpStatusCode responseStatusCode, DittoHeaders dittoHeaders) {
        super(TYPE, thingId, message, responseStatusCode, dittoHeaders);
    }

    @Override
    public SendClaimMessageResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return SendClaimMessageResponse.of(this.getThingEntityId(), this.getMessage(), this.getStatusCode(), dittoHeaders);
    }

    @Deprecated
    public static <T> SendClaimMessageResponse<T> of(String thingId, Message<T> message, HttpStatusCode responseStatusCode, DittoHeaders dittoHeaders) {
        return SendClaimMessageResponse.of(ThingId.of((CharSequence)thingId), message, responseStatusCode, dittoHeaders);
    }

    public static <T> SendClaimMessageResponse<T> of(ThingId thingId, Message<T> message, HttpStatusCode responseStatusCode, DittoHeaders dittoHeaders) {
        return new SendClaimMessageResponse<T>(thingId, message, responseStatusCode, dittoHeaders);
    }

    public static <T> SendClaimMessageResponse<T> fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return SendClaimMessageResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static <T> SendClaimMessageResponse<T> fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SendClaimMessageResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String extractedThingId = (String)jsonObject.getValueOrThrow(MessageCommandResponse.JsonFields.JSON_THING_ID);
            ThingId thingId = ThingId.of((CharSequence)extractedThingId);
            Message message = SendClaimMessageResponse.deserializeMessageFromJson(jsonObject);
            return SendClaimMessageResponse.of(thingId, message, statusCode, dittoHeaders);
        });
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SendClaimMessageResponse;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + "]";
    }
}

