/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.messages.MessageHeaders;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.messages.AbstractMessageCommandResponse;
import org.eclipse.ditto.signals.commands.messages.MessageCommandResponse;

@JsonParsableCommandResponse(type="messages.responses:acceptedResponseMessage")
@Immutable
public final class SendMessageAcceptedResponse
extends AbstractMessageCommandResponse<Void, SendMessageAcceptedResponse> {
    public static final String NAME = "acceptedResponseMessage";
    public static final String TYPE = "messages.responses:acceptedResponseMessage";

    private SendMessageAcceptedResponse(ThingId thingId, MessageHeaders messageHeaders, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, thingId, Message.newBuilder((MessageHeaders)messageHeaders).build(), statusCode, dittoHeaders);
    }

    @Deprecated
    public static SendMessageAcceptedResponse newInstance(String thingId, MessageHeaders messageHeaders, DittoHeaders dittoHeaders) {
        return SendMessageAcceptedResponse.newInstance(ThingId.of((CharSequence)thingId), messageHeaders, dittoHeaders);
    }

    public static SendMessageAcceptedResponse newInstance(ThingId thingId, MessageHeaders messageHeaders, DittoHeaders dittoHeaders) {
        return SendMessageAcceptedResponse.newInstance(thingId, messageHeaders, HttpStatusCode.ACCEPTED, dittoHeaders);
    }

    @Deprecated
    public static SendMessageAcceptedResponse newInstance(String thingId, MessageHeaders messageHeaders, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        return SendMessageAcceptedResponse.newInstance(ThingId.of((CharSequence)thingId), messageHeaders, statusCode, dittoHeaders);
    }

    public static SendMessageAcceptedResponse newInstance(ThingId thingId, MessageHeaders messageHeaders, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        return new SendMessageAcceptedResponse(thingId, messageHeaders, statusCode, dittoHeaders);
    }

    public static SendMessageAcceptedResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return SendMessageAcceptedResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static SendMessageAcceptedResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SendMessageAcceptedResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String extractedThingId = (String)jsonObject.getValueOrThrow(MessageCommandResponse.JsonFields.JSON_THING_ID);
            ThingId thingId = ThingId.of((CharSequence)extractedThingId);
            JsonObject jsonHeaders = (JsonObject)((JsonObject)jsonObject.getValueOrThrow(MessageCommandResponse.JsonFields.JSON_MESSAGE)).getValueOrThrow(MessageCommandResponse.JsonFields.JSON_MESSAGE_HEADERS);
            MessageHeaders messageHeaders = MessageHeaders.of((JsonObject)jsonHeaders);
            return SendMessageAcceptedResponse.newInstance(thingId, messageHeaders, statusCode, dittoHeaders);
        });
    }

    @Override
    public SendMessageAcceptedResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return SendMessageAcceptedResponse.newInstance(this.getThingEntityId(), this.getMessage().getHeaders(), this.getStatusCode(), dittoHeaders);
    }

    public Optional<String> getCorrelationId() {
        return this.getDittoHeaders().getCorrelationId();
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SendMessageAcceptedResponse;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + "]";
    }
}

