/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.messages.MessageBuilder;
import org.eclipse.ditto.model.messages.MessageHeaders;
import org.eclipse.ditto.model.messages.ThingIdInvalidException;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.commands.messages.MessagePayloadSerializer;

abstract class AbstractMessageCommand<T, C extends AbstractMessageCommand>
extends AbstractCommand<C>
implements MessageCommand<T, C> {
    private final ThingId thingId;
    private final Message<T> message;

    AbstractMessageCommand(String type, ThingId thingId, Message<T> message, DittoHeaders dittoHeaders) {
        super(type, dittoHeaders);
        this.thingId = (ThingId)ConditionChecker.checkNotNull((Object)thingId, (String)"thingId");
        this.message = (Message)ConditionChecker.checkNotNull(message, (String)"message");
        this.validateThingId(message.getThingEntityId(), dittoHeaders);
    }

    private void validateThingId(ThingId thingIdFromMessage, DittoHeaders dittoHeaders) {
        if (!this.thingId.equals((Object)thingIdFromMessage)) {
            String descTemplate = "It does not match the 'thingId' from the Message the command transports (<{0}>). Please ensure that they are equal.";
            throw (ThingIdInvalidException)ThingIdInvalidException.newBuilder((CharSequence)String.valueOf(this.thingId)).description(MessageFormat.format("It does not match the 'thingId' from the Message the command transports (<{0}>). Please ensure that they are equal.", thingIdFromMessage)).dittoHeaders(dittoHeaders).build();
        }
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    public ThingId getThingEntityId() {
        return this.thingId;
    }

    @Override
    public Message<T> getMessage() {
        return this.message;
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(MessageCommand.JsonFields.JSON_THING_ID, (Object)this.getThingEntityId().toString(), predicate);
        JsonObjectBuilder messageBuilder = JsonFactory.newObjectBuilder();
        JsonObject headersObject = (JsonObject)this.message.getHeaders().toJson();
        messageBuilder.set(MessageCommand.JsonFields.JSON_MESSAGE_HEADERS, (Object)headersObject, predicate);
        MessagePayloadSerializer.serialize(this.message, messageBuilder, predicate);
        JsonObject messageObject = messageBuilder.build();
        jsonObjectBuilder.set(MessageCommand.JsonFields.JSON_MESSAGE, (Object)messageObject, predicate);
    }

    protected static <T> Message<T> deserializeMessageFromJson(JsonObject jsonObject) {
        JsonObject messageObject = (JsonObject)jsonObject.getValueOrThrow(MessageCommand.JsonFields.JSON_MESSAGE);
        JsonObject messageHeadersObject = (JsonObject)messageObject.getValueOrThrow(MessageCommand.JsonFields.JSON_MESSAGE_HEADERS);
        Optional messagePayloadOptional = messageObject.getValue(MessageCommand.JsonFields.JSON_MESSAGE_PAYLOAD);
        MessageHeaders messageHeaders = MessageHeaders.of((JsonObject)messageHeadersObject);
        MessageBuilder messageBuilder = Message.newBuilder((MessageHeaders)messageHeaders);
        MessagePayloadSerializer.deserialize(messagePayloadOptional, messageBuilder, messageHeaders);
        return messageBuilder.build();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.thingId, this.message);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMessageCommand other = (AbstractMessageCommand)obj;
        return other.canEqual(this) && Objects.equals(this.thingId, other.thingId) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractMessageCommand;
    }

    public String toString() {
        return "thingId=" + this.thingId + ", message=" + this.message;
    }

    @Override
    public abstract C setDittoHeaders(DittoHeaders var1);
}

