/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.messages.MessageDirection;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.WithThingId;
import org.eclipse.ditto.signals.commands.base.Command;

public interface MessageCommand<T, C extends MessageCommand>
extends Command<C>,
WithThingId {
    public static final String TYPE_PREFIX = "messages.commands:";
    public static final String INBOX_PREFIX = "inbox";
    public static final String OUTBOX_PREFIX = "outbox";
    public static final String FEATURES_PREFIX = "features";
    public static final String MESSAGES_PREFIX = "messages";
    public static final String RESOURCE_TYPE = "message";

    public Message<T> getMessage();

    default public String getTypePrefix() {
        return TYPE_PREFIX;
    }

    default public String getMessageType() {
        return this.getName();
    }

    default public ThingId getEntityId() {
        return this.getThingEntityId();
    }

    default public String getResourceType() {
        return RESOURCE_TYPE;
    }

    public C setDittoHeaders(DittoHeaders var1);

    default public JsonPointer getResourcePath() {
        Message<T> message = this.getMessage();
        String box = message.getDirection() == MessageDirection.TO ? INBOX_PREFIX : OUTBOX_PREFIX;
        JsonPointer pathSuffix = JsonPointer.empty().addLeaf(JsonKey.of((CharSequence)box)).addLeaf(JsonKey.of((CharSequence)MESSAGES_PREFIX)).addLeaf(JsonKey.of((CharSequence)message.getSubject()));
        JsonPointer path = message.getFeatureId().map(fId -> JsonPointer.empty().addLeaf(JsonKey.of((CharSequence)FEATURES_PREFIX)).addLeaf(JsonKey.of((CharSequence)fId))).orElse(JsonPointer.empty());
        return path.append(pathSuffix);
    }

    public static class JsonFields
    extends Command.JsonFields {
        public static final JsonFieldDefinition<String> JSON_THING_ID = JsonFactory.newStringFieldDefinition((CharSequence)"thingId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> JSON_MESSAGE = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"message", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> JSON_MESSAGE_HEADERS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"headers", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonValue> JSON_MESSAGE_PAYLOAD = JsonFactory.newJsonValueFieldDefinition((CharSequence)"payload", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    }
}

