/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.messages.MessageBuilder;
import org.eclipse.ditto.model.messages.MessageHeaders;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.commands.messages.MessageCommandSizeValidator;

class MessagePayloadSerializer {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String APPLICATION_JSON = "application/json";
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    private MessagePayloadSerializer() {
    }

    static <T> void serialize(Message<T> message, JsonObjectBuilder messageBuilder, Predicate<JsonField> predicate) {
        Optional rawPayloadOptional = message.getRawPayload();
        Optional payloadOptional = message.getPayload();
        if (rawPayloadOptional.isPresent() && !payloadOptional.filter(p -> p instanceof JsonValue).isPresent()) {
            String encodedString;
            ByteBuffer rawPayload = (ByteBuffer)rawPayloadOptional.get();
            if (MessagePayloadSerializer.shouldBeInterpretedAsText(message.getContentType().orElse(""))) {
                encodedString = new String(rawPayload.array());
            } else {
                ByteBuffer base64Encoded = BASE64_ENCODER.encode(rawPayload);
                encodedString = new String(base64Encoded.array(), StandardCharsets.UTF_8);
            }
            MessagePayloadSerializer.injectMessagePayload(messageBuilder, predicate, encodedString, message.getHeaders());
        } else if (payloadOptional.isPresent()) {
            Object payload = payloadOptional.get();
            if (payload instanceof JsonValue) {
                JsonValue payloadAsJsonValue = (JsonValue)payload;
                MessageCommandSizeValidator.getInstance().ensureValidSize(() -> ((JsonValue)payloadAsJsonValue).getUpperBoundForStringSize(), () -> payloadAsJsonValue.toString().length(), () -> message.getHeaders());
                messageBuilder.set(MessageCommand.JsonFields.JSON_MESSAGE_PAYLOAD, (Object)((JsonValue)payload), predicate);
            } else {
                MessagePayloadSerializer.injectMessagePayload(messageBuilder, predicate, payload.toString(), message.getHeaders());
            }
        }
    }

    private static void injectMessagePayload(JsonObjectBuilder messageBuilder, Predicate<JsonField> predicate, String encodedString, MessageHeaders messageHeaders) {
        MessageCommandSizeValidator.getInstance().ensureValidSize(encodedString::length, () -> messageHeaders);
        messageBuilder.set(MessageCommand.JsonFields.JSON_MESSAGE_PAYLOAD, (Object)JsonValue.of((String)encodedString), predicate);
    }

    static void deserialize(Optional<JsonValue> messagePayloadOptional, MessageBuilder messageBuilder, MessageHeaders messageHeaders) {
        String contentType = messageHeaders.getContentType().orElse("");
        if (messagePayloadOptional.isPresent()) {
            JsonValue payload = messagePayloadOptional.get();
            if (MessagePayloadSerializer.shouldBeInterpretedAsText(contentType)) {
                messageBuilder.payload((Object)(payload.isString() ? payload.asString() : payload));
            } else {
                String payloadStr = payload.isString() ? payload.asString() : payload.toString();
                byte[] payloadBytes = payloadStr.getBytes(StandardCharsets.UTF_8);
                MessageCommandSizeValidator.getInstance().ensureValidSize(() -> payloadBytes.length, () -> messageHeaders);
                messageBuilder.rawPayload(ByteBuffer.wrap(BASE64_DECODER.decode(payloadBytes)));
            }
        }
    }

    private static boolean shouldBeInterpretedAsText(String contentType) {
        return contentType.startsWith(TEXT_PLAIN) || contentType.startsWith(APPLICATION_JSON);
    }
}

