/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonParsableCommand;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.messages.FeatureIdInvalidException;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.base.WithFeatureId;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.messages.AbstractMessageCommand;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;

@JsonParsableCommand(typePrefix="messages.commands:", name="featureMessage")
@Immutable
public final class SendFeatureMessage<T>
extends AbstractMessageCommand<T, SendFeatureMessage>
implements WithFeatureId {
    public static final String NAME = "featureMessage";
    public static final String TYPE = "messages.commands:featureMessage";
    static final JsonFieldDefinition<String> JSON_FEATURE_ID = JsonFactory.newStringFieldDefinition((CharSequence)"featureId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    private final String featureId;

    private SendFeatureMessage(ThingId thingId, String featureId, Message<T> message, DittoHeaders dittoHeaders) {
        super(TYPE, thingId, message, dittoHeaders);
        this.featureId = (String)ConditionChecker.checkNotNull((Object)featureId, (String)"featureId");
        SendFeatureMessage.validateMessageFeatureId(featureId, message, dittoHeaders);
    }

    private static void validateMessageFeatureId(String expectedFeatureId, Message<?> message, DittoHeaders dittoHeaders) {
        Optional messageFeatureIdOptional = message.getFeatureId();
        if (!messageFeatureIdOptional.isPresent()) {
            String msgPattern = "The Message did not contain a feature ID at all! Expected was feature ID <{0}>.";
            throw (FeatureIdInvalidException)FeatureIdInvalidException.newBuilder().message(MessageFormat.format("The Message did not contain a feature ID at all! Expected was feature ID <{0}>.", expectedFeatureId)).dittoHeaders(dittoHeaders).build();
        }
        String messageFeatureId = (String)messageFeatureIdOptional.get();
        if (!messageFeatureId.equals(expectedFeatureId)) {
            String msgPattern = "The Message contained feature ID <{0}>. Expected was feature ID <{1}>.";
            throw (FeatureIdInvalidException)FeatureIdInvalidException.newBuilder().message(MessageFormat.format("The Message contained feature ID <{0}>. Expected was feature ID <{1}>.", messageFeatureId, expectedFeatureId)).dittoHeaders(dittoHeaders).build();
        }
    }

    @Deprecated
    public static <T> SendFeatureMessage<T> of(String thingId, String featureId, Message<T> message, DittoHeaders dittoHeaders) {
        return SendFeatureMessage.of(ThingId.of((CharSequence)thingId), featureId, message, dittoHeaders);
    }

    public static <T> SendFeatureMessage<T> of(ThingId thingId, String featureId, Message<T> message, DittoHeaders dittoHeaders) {
        return new SendFeatureMessage<T>(thingId, featureId, message, dittoHeaders);
    }

    public static <T> SendFeatureMessage<T> fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return SendFeatureMessage.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static <T> SendFeatureMessage<T> fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SendFeatureMessage)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String extractedThingId = (String)jsonObject.getValueOrThrow(MessageCommand.JsonFields.JSON_THING_ID);
            ThingId thingId = ThingId.of((CharSequence)extractedThingId);
            String featureId = (String)jsonObject.getValueOrThrow(JSON_FEATURE_ID);
            Message message = SendFeatureMessage.deserializeMessageFromJson(jsonObject);
            return SendFeatureMessage.of(thingId, featureId, message, dittoHeaders);
        });
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    public SendFeatureMessage setDittoHeaders(DittoHeaders dittoHeaders) {
        return SendFeatureMessage.of(this.getThingEntityId(), this.featureId, this.getMessage(), dittoHeaders);
    }

    @Override
    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        super.appendPayload(jsonObjectBuilder, schemaVersion, predicate);
        jsonObjectBuilder.remove(MessageCommand.JsonFields.JSON_THING_ID);
        JsonObject superBuild = jsonObjectBuilder.build();
        jsonObjectBuilder.removeAll();
        jsonObjectBuilder.set(MessageCommand.JsonFields.JSON_THING_ID, (Object)this.getThingEntityId().toString());
        jsonObjectBuilder.set(JSON_FEATURE_ID, (Object)this.getFeatureId());
        jsonObjectBuilder.setAll((Iterable)superBuild);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.featureId);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SendFeatureMessage that = (SendFeatureMessage)obj;
        return that.canEqual(this) && Objects.equals(this.featureId, that.featureId) && super.equals(that);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SendFeatureMessage;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", featureId=" + this.featureId + "]";
    }
}

